# CustomerFilter

### Description

Represents a set of `CustomerQuery` filters used to limit the set of `Customers` returned by `SearchCustomers`.

## Properties
Name | Getter | Setter | Type | Description | Notes
------------ | ------------- | ------------- | ------------- | ------------- | -------------
**creation_source** | getCreationSource() | setCreationSource($value) | [**\SquareConnect\Model\CustomerCreationSourceFilter**](CustomerCreationSourceFilter.md) | A filter to select customers based on their creation source. | [optional] 
**created_at** | getCreatedAt() | setCreatedAt($value) | [**\SquareConnect\Model\TimeRange**](TimeRange.md) | A filter to select customers based on when they were created. | [optional] 
**updated_at** | getUpdatedAt() | setUpdatedAt($value) | [**\SquareConnect\Model\TimeRange**](TimeRange.md) | A filter to select customers based on when they were updated. | [optional] 
**email_address** | getEmailAddress() | setEmailAddress($value) | [**\SquareConnect\Model\CustomerTextFilter**](CustomerTextFilter.md) | A filter to [select customers by email address](https://developer.squareup.com/docs/docs/customers-api/cookbook/search-customers#search-by-email-address)  visible to the seller.  This filter is case insensitive.  For [exact matching](https://developer.squareup.com/docs/docs/customers-api/cookbook/search-customers#exact-search-by-email-address), this filter causes the search to return customer profiles  whose &#x60;email_address&#x60; field value are identical to the email address provided in the query.  For [fuzzy matching](https://developer.squareup.com/docs/docs/customers-api/cookbook/search-customers#fuzzy-search-by-email-address),  this filter causes the search to return customer profiles  whose &#x60;email_address&#x60; field value has a token-wise partial match against the filtering  expression in the query. For example, with &#x60;Steven gmail&#x60; provided in a search query, the search returns customers whose email address can be &#x60;steven.johnson&amp;#64;gmail.com&#x60;  or &#x60;mygmail&amp;#64;stevensbakery.com&#x60;. Email addresses are tokenized by replacing, by spaces,  punctuations including periods (&#x60;.&#x60;), underscores (&#x60;_&#x60;), and the &#x60;&amp;#64;&#x60; symbols. A match is found if a tokenized email address contains all the tokens in the search query,  irrespective of the token order. | [optional] 
**phone_number** | getPhoneNumber() | setPhoneNumber($value) | [**\SquareConnect\Model\CustomerTextFilter**](CustomerTextFilter.md) | A filter to [select customers by their phone numbers](https://developer.squareup.com/docs/docs/customers-api/cookbook/search-customers#search-by-phone-number) visible to the seller.  This filter is case insensitive.   For [exact matching](https://developer.squareup.com/docs/docs/customers-api/cookbook/search-customers#exact-search-by-phone-number),  this filter causes the search to return customers whose phone number matches the specified query expression. The number in the query must be of an E.164-compliant form. In particular, it must include the leading &#x60;+&#x60; sign followed by a contry code and then a subscriber number. The standard E.614 form of a US phone number is &#x60;+12061112222&#x60; of the domestic version or &#x60;+0012061112222&#x60; of the international version. The E.164-compliant variations include &#x60;+1 (206) 111-2222&#x60; or &#x60;+001 (206) 111-2222&#x60;, respectively. To match the query expression, stored customers&#39; phone numbers are converted to the standard E.164 form of the national and internationalized versions.   For [fuzzy matching](https://developer.squareup.com/docs/docs/customers-api/cookbook/search-customers#fuzzy-search-by-phone-number),  this filter causes the search to return customers whose phone number matches partially  the token or tokens provided in the query expression. For example, if the search query contains  &#x60;415-123-45&#x60;, the filter selects those customers with phone numbers of &#x60;415-123-4567&#x60; or  &#x60;234-151-2345&#x60;. The search does not return customers with the phone number of &#x60;415-123-4678&#x60;. Similarly, if the search query contains &#x60;415&#x60; as part of the phone number, the search returns those customers with phone numbers of &#x60;(415)-123-4567&#x60;, &#x60;(123) 415-1567&#x60;, and &#x60;1 (415) 123-4567&#x60;. | [optional] 
**reference_id** | getReferenceId() | setReferenceId($value) | [**\SquareConnect\Model\CustomerTextFilter**](CustomerTextFilter.md) | A filter to [select customers by their reference IDs](https://developer.squareup.com/docs/docs/customers-api/cookbook/search-customers#search-by-reference-id). This filter is case insensitive.  [Exact matching](https://developer.squareup.com/docs/docs/customers-api/cookbook/search-customers#exact-search-by-reference-id)  of a customer&#39;s reference ID against a query&#39;s reference ID is evaluated as exact match between two strings, character by character in the given order.  [Fuzzy matching](https://developer.squareup.com/docs/docs/customers-api/cookbook/search-customers#fuzzy-search-by-reference-id) of stored reference IDs against queried reference IDs works  exactly the same as fuzzy matching on email addresses. Non-alphanumeric characters  are replaced by spaces to tokenize stored and queried reference IDs. A match is found if a tokenized stored reference ID contains all tokens specified in any order in the query. For example, a query of &#x60;NYC M&#x60; will match customer profiles with the &#x60;reference_id&#x60; value of &#x60;NYC_M_35_JOHNSON&#x60; and &#x60;NYC_27_MURRAY&#x60;. | [optional] 
**group_ids** | getGroupIds() | setGroupIds($value) | [**\SquareConnect\Model\FilterValue**](FilterValue.md) | A filter to select customers based on their group membership.  The &#x60;group_ids&#x60; is a JSON object of the following general format: &#x60;&#x60;&#x60; \&quot;group_ids\&quot;: { \&quot;any\&quot;:  [\&quot;{group_a_id}\&quot;, \&quot;{group_b_id}\&quot;, ...], \&quot;all\&quot;:  [\&quot;{group_1_id}\&quot;, \&quot;{group_2_id}\&quot;, ...], &#39;none\&quot;: [\&quot;{group_i_id}\&quot;, \&quot;{group_ii_id}\&quot;, ...] } &#x60;&#x60;&#x60;  You can use any combination of the above &#x60;group_ids&#x60; fields (also known as &#x60;FilterValue&#x60; properties)  to specify how customers are selected based on their group membership.   With the &#x60;any&#x60; option, the search returns customers in Groups &#x60;A&#x60; or &#x60;B&#x60; or ... of the list. With the &#x60;all&#x60; option, the search returns customers in Groups &#x60;1&#x60; and &#x60;2&#x60; and ... of the list. With the &#x60;none&#x60; option, the search returns customers not in Groups &#x60;i&#x60; and not in &#x60;ii&#x60; and not in ... of the list.  If any of the search conditions are not met, including when an invalid or non-existent group ID is provided, the result is an empty list.   You can use the &#x60;group_ids&#x60; search filter with other available filters.   You cannot use the &#x60;group_ids&#x60; filter to select customers based on segment membership. | [optional] 

Note: All properties are protected and only accessed via getters and setters.

[[Back to Model list]](../../README.md#documentation-for-models) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to README]](../../README.md)

