<?php
/**
 * EmailClientApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * EmailClientApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class EmailClientApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createEmailAutoresponder' => [
            'application/json',
        ],
        'deleteEmailAutoresponder' => [
            'application/json',
        ],
        'getEmailAutoresponders' => [
            'application/json',
        ],
        'getEmailForwarders' => [
            'application/json',
        ],
        'getEmailPublicIp' => [
            'application/json',
        ],
        'updateEmailAutoresponder' => [
            'application/json',
        ],
        'updateEmailForwarders' => [
            'application/json',
        ],
        'updateEmailPassword' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createEmailAutoresponder
     *
     * Create new email autoresponder
     *
     * @param  string $authorization authorization (required)
     * @param  string $address address (required)
     * @param  string $password password (required)
     * @param  \OpenAPI\Client\Model\NewAutoresponder $new_autoresponder Autoresponder details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceId
     */
    public function createEmailAutoresponder($authorization, $address, $password, $new_autoresponder, string $contentType = self::contentTypes['createEmailAutoresponder'][0])
    {
        list($response) = $this->createEmailAutoresponderWithHttpInfo($authorization, $address, $password, $new_autoresponder, $contentType);
        return $response;
    }

    /**
     * Operation createEmailAutoresponderWithHttpInfo
     *
     * Create new email autoresponder
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\NewAutoresponder $new_autoresponder Autoresponder details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceId, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmailAutoresponderWithHttpInfo($authorization, $address, $password, $new_autoresponder, string $contentType = self::contentTypes['createEmailAutoresponder'][0])
    {
        $request = $this->createEmailAutoresponderRequest($authorization, $address, $password, $new_autoresponder, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\NewResourceId',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\NewResourceId',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceId',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createEmailAutoresponderAsync
     *
     * Create new email autoresponder
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\NewAutoresponder $new_autoresponder Autoresponder details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmailAutoresponderAsync($authorization, $address, $password, $new_autoresponder, string $contentType = self::contentTypes['createEmailAutoresponder'][0])
    {
        return $this->createEmailAutoresponderAsyncWithHttpInfo($authorization, $address, $password, $new_autoresponder, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createEmailAutoresponderAsyncWithHttpInfo
     *
     * Create new email autoresponder
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\NewAutoresponder $new_autoresponder Autoresponder details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmailAutoresponderAsyncWithHttpInfo($authorization, $address, $password, $new_autoresponder, string $contentType = self::contentTypes['createEmailAutoresponder'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceId';
        $request = $this->createEmailAutoresponderRequest($authorization, $address, $password, $new_autoresponder, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmailAutoresponder'
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\NewAutoresponder $new_autoresponder Autoresponder details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createEmailAutoresponderRequest($authorization, $address, $password, $new_autoresponder, string $contentType = self::contentTypes['createEmailAutoresponder'][0])
    {

        // verify the required parameter 'authorization' is set
        if ($authorization === null || (is_array($authorization) && count($authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling createEmailAutoresponder'
            );
        }

        // verify the required parameter 'address' is set
        if ($address === null || (is_array($address) && count($address) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $address when calling createEmailAutoresponder'
            );
        }

        // verify the required parameter 'password' is set
        if ($password === null || (is_array($password) && count($password) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $password when calling createEmailAutoresponder'
            );
        }

        // verify the required parameter 'new_autoresponder' is set
        if ($new_autoresponder === null || (is_array($new_autoresponder) && count($new_autoresponder) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_autoresponder when calling createEmailAutoresponder'
            );
        }


        $resourcePath = '/email-client/autoresponders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }
        // header params
        if ($address !== null) {
            $headerParams['Address'] = ObjectSerializer::toHeaderValue($address);
        }
        // header params
        if ($password !== null) {
            $headerParams['Password'] = ObjectSerializer::toHeaderValue($password);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_autoresponder)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_autoresponder));
            } else {
                $httpBody = $new_autoresponder;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteEmailAutoresponder
     *
     * Delete email autoresponder
     *
     * @param  string $authorization authorization (required)
     * @param  string $address address (required)
     * @param  string $password password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteEmailAutoresponder($authorization, $address, $password, string $contentType = self::contentTypes['deleteEmailAutoresponder'][0])
    {
        $this->deleteEmailAutoresponderWithHttpInfo($authorization, $address, $password, $contentType);
    }

    /**
     * Operation deleteEmailAutoresponderWithHttpInfo
     *
     * Delete email autoresponder
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEmailAutoresponderWithHttpInfo($authorization, $address, $password, string $contentType = self::contentTypes['deleteEmailAutoresponder'][0])
    {
        $request = $this->deleteEmailAutoresponderRequest($authorization, $address, $password, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteEmailAutoresponderAsync
     *
     * Delete email autoresponder
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEmailAutoresponderAsync($authorization, $address, $password, string $contentType = self::contentTypes['deleteEmailAutoresponder'][0])
    {
        return $this->deleteEmailAutoresponderAsyncWithHttpInfo($authorization, $address, $password, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteEmailAutoresponderAsyncWithHttpInfo
     *
     * Delete email autoresponder
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEmailAutoresponderAsyncWithHttpInfo($authorization, $address, $password, string $contentType = self::contentTypes['deleteEmailAutoresponder'][0])
    {
        $returnType = '';
        $request = $this->deleteEmailAutoresponderRequest($authorization, $address, $password, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteEmailAutoresponder'
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteEmailAutoresponderRequest($authorization, $address, $password, string $contentType = self::contentTypes['deleteEmailAutoresponder'][0])
    {

        // verify the required parameter 'authorization' is set
        if ($authorization === null || (is_array($authorization) && count($authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling deleteEmailAutoresponder'
            );
        }

        // verify the required parameter 'address' is set
        if ($address === null || (is_array($address) && count($address) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $address when calling deleteEmailAutoresponder'
            );
        }

        // verify the required parameter 'password' is set
        if ($password === null || (is_array($password) && count($password) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $password when calling deleteEmailAutoresponder'
            );
        }


        $resourcePath = '/email-client/autoresponders/{autoresponder_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }
        // header params
        if ($address !== null) {
            $headerParams['Address'] = ObjectSerializer::toHeaderValue($address);
        }
        // header params
        if ($password !== null) {
            $headerParams['Password'] = ObjectSerializer::toHeaderValue($password);
        }



        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmailAutoresponders
     *
     * Get email account autoresponder
     *
     * @param  string $authorization authorization (required)
     * @param  string $address address (required)
     * @param  string $password password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailAutoresponders'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Autoresponder
     */
    public function getEmailAutoresponders($authorization, $address, $password, string $contentType = self::contentTypes['getEmailAutoresponders'][0])
    {
        list($response) = $this->getEmailAutorespondersWithHttpInfo($authorization, $address, $password, $contentType);
        return $response;
    }

    /**
     * Operation getEmailAutorespondersWithHttpInfo
     *
     * Get email account autoresponder
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailAutoresponders'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Autoresponder, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmailAutorespondersWithHttpInfo($authorization, $address, $password, string $contentType = self::contentTypes['getEmailAutoresponders'][0])
    {
        $request = $this->getEmailAutorespondersRequest($authorization, $address, $password, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Autoresponder',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Autoresponder',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Autoresponder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getEmailAutorespondersAsync
     *
     * Get email account autoresponder
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailAutoresponders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmailAutorespondersAsync($authorization, $address, $password, string $contentType = self::contentTypes['getEmailAutoresponders'][0])
    {
        return $this->getEmailAutorespondersAsyncWithHttpInfo($authorization, $address, $password, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEmailAutorespondersAsyncWithHttpInfo
     *
     * Get email account autoresponder
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailAutoresponders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmailAutorespondersAsyncWithHttpInfo($authorization, $address, $password, string $contentType = self::contentTypes['getEmailAutoresponders'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Autoresponder';
        $request = $this->getEmailAutorespondersRequest($authorization, $address, $password, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmailAutoresponders'
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailAutoresponders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEmailAutorespondersRequest($authorization, $address, $password, string $contentType = self::contentTypes['getEmailAutoresponders'][0])
    {

        // verify the required parameter 'authorization' is set
        if ($authorization === null || (is_array($authorization) && count($authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling getEmailAutoresponders'
            );
        }

        // verify the required parameter 'address' is set
        if ($address === null || (is_array($address) && count($address) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $address when calling getEmailAutoresponders'
            );
        }

        // verify the required parameter 'password' is set
        if ($password === null || (is_array($password) && count($password) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $password when calling getEmailAutoresponders'
            );
        }


        $resourcePath = '/email-client/autoresponders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }
        // header params
        if ($address !== null) {
            $headerParams['Address'] = ObjectSerializer::toHeaderValue($address);
        }
        // header params
        if ($password !== null) {
            $headerParams['Password'] = ObjectSerializer::toHeaderValue($password);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmailForwarders
     *
     * Returns email account&#39;s forwarders
     *
     * @param  string $authorization authorization (required)
     * @param  string $address address (required)
     * @param  string $password password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailForwarders'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ForwardersFullListing
     */
    public function getEmailForwarders($authorization, $address, $password, string $contentType = self::contentTypes['getEmailForwarders'][0])
    {
        list($response) = $this->getEmailForwardersWithHttpInfo($authorization, $address, $password, $contentType);
        return $response;
    }

    /**
     * Operation getEmailForwardersWithHttpInfo
     *
     * Returns email account&#39;s forwarders
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailForwarders'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ForwardersFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmailForwardersWithHttpInfo($authorization, $address, $password, string $contentType = self::contentTypes['getEmailForwarders'][0])
    {
        $request = $this->getEmailForwardersRequest($authorization, $address, $password, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ForwardersFullListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ForwardersFullListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ForwardersFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getEmailForwardersAsync
     *
     * Returns email account&#39;s forwarders
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailForwarders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmailForwardersAsync($authorization, $address, $password, string $contentType = self::contentTypes['getEmailForwarders'][0])
    {
        return $this->getEmailForwardersAsyncWithHttpInfo($authorization, $address, $password, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEmailForwardersAsyncWithHttpInfo
     *
     * Returns email account&#39;s forwarders
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailForwarders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmailForwardersAsyncWithHttpInfo($authorization, $address, $password, string $contentType = self::contentTypes['getEmailForwarders'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ForwardersFullListing';
        $request = $this->getEmailForwardersRequest($authorization, $address, $password, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmailForwarders'
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailForwarders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEmailForwardersRequest($authorization, $address, $password, string $contentType = self::contentTypes['getEmailForwarders'][0])
    {

        // verify the required parameter 'authorization' is set
        if ($authorization === null || (is_array($authorization) && count($authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling getEmailForwarders'
            );
        }

        // verify the required parameter 'address' is set
        if ($address === null || (is_array($address) && count($address) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $address when calling getEmailForwarders'
            );
        }

        // verify the required parameter 'password' is set
        if ($password === null || (is_array($password) && count($password) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $password when calling getEmailForwarders'
            );
        }


        $resourcePath = '/email-client/forwarders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }
        // header params
        if ($address !== null) {
            $headerParams['Address'] = ObjectSerializer::toHeaderValue($address);
        }
        // header params
        if ($password !== null) {
            $headerParams['Password'] = ObjectSerializer::toHeaderValue($password);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmailPublicIp
     *
     * Returns public Ip Address of the email server
     *
     * @param  string $authorization authorization (required)
     * @param  string $address address (required)
     * @param  string $password password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailPublicIp'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\EmailPublicIp
     */
    public function getEmailPublicIp($authorization, $address, $password, string $contentType = self::contentTypes['getEmailPublicIp'][0])
    {
        list($response) = $this->getEmailPublicIpWithHttpInfo($authorization, $address, $password, $contentType);
        return $response;
    }

    /**
     * Operation getEmailPublicIpWithHttpInfo
     *
     * Returns public Ip Address of the email server
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailPublicIp'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\EmailPublicIp, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmailPublicIpWithHttpInfo($authorization, $address, $password, string $contentType = self::contentTypes['getEmailPublicIp'][0])
    {
        $request = $this->getEmailPublicIpRequest($authorization, $address, $password, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\EmailPublicIp',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\EmailPublicIp',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\EmailPublicIp',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getEmailPublicIpAsync
     *
     * Returns public Ip Address of the email server
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailPublicIp'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmailPublicIpAsync($authorization, $address, $password, string $contentType = self::contentTypes['getEmailPublicIp'][0])
    {
        return $this->getEmailPublicIpAsyncWithHttpInfo($authorization, $address, $password, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEmailPublicIpAsyncWithHttpInfo
     *
     * Returns public Ip Address of the email server
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailPublicIp'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmailPublicIpAsyncWithHttpInfo($authorization, $address, $password, string $contentType = self::contentTypes['getEmailPublicIp'][0])
    {
        $returnType = '\OpenAPI\Client\Model\EmailPublicIp';
        $request = $this->getEmailPublicIpRequest($authorization, $address, $password, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmailPublicIp'
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailPublicIp'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEmailPublicIpRequest($authorization, $address, $password, string $contentType = self::contentTypes['getEmailPublicIp'][0])
    {

        // verify the required parameter 'authorization' is set
        if ($authorization === null || (is_array($authorization) && count($authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling getEmailPublicIp'
            );
        }

        // verify the required parameter 'address' is set
        if ($address === null || (is_array($address) && count($address) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $address when calling getEmailPublicIp'
            );
        }

        // verify the required parameter 'password' is set
        if ($password === null || (is_array($password) && count($password) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $password when calling getEmailPublicIp'
            );
        }


        $resourcePath = '/email-client/public-ip';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }
        // header params
        if ($address !== null) {
            $headerParams['Address'] = ObjectSerializer::toHeaderValue($address);
        }
        // header params
        if ($password !== null) {
            $headerParams['Password'] = ObjectSerializer::toHeaderValue($password);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmailAutoresponder
     *
     * Update email autoresponder
     *
     * @param  string $authorization authorization (required)
     * @param  string $address address (required)
     * @param  string $password password (required)
     * @param  \OpenAPI\Client\Model\UpdateAutoresponder $update_autoresponder Autoresponder update details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateEmailAutoresponder($authorization, $address, $password, $update_autoresponder, string $contentType = self::contentTypes['updateEmailAutoresponder'][0])
    {
        $this->updateEmailAutoresponderWithHttpInfo($authorization, $address, $password, $update_autoresponder, $contentType);
    }

    /**
     * Operation updateEmailAutoresponderWithHttpInfo
     *
     * Update email autoresponder
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\UpdateAutoresponder $update_autoresponder Autoresponder update details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmailAutoresponderWithHttpInfo($authorization, $address, $password, $update_autoresponder, string $contentType = self::contentTypes['updateEmailAutoresponder'][0])
    {
        $request = $this->updateEmailAutoresponderRequest($authorization, $address, $password, $update_autoresponder, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateEmailAutoresponderAsync
     *
     * Update email autoresponder
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\UpdateAutoresponder $update_autoresponder Autoresponder update details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmailAutoresponderAsync($authorization, $address, $password, $update_autoresponder, string $contentType = self::contentTypes['updateEmailAutoresponder'][0])
    {
        return $this->updateEmailAutoresponderAsyncWithHttpInfo($authorization, $address, $password, $update_autoresponder, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateEmailAutoresponderAsyncWithHttpInfo
     *
     * Update email autoresponder
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\UpdateAutoresponder $update_autoresponder Autoresponder update details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmailAutoresponderAsyncWithHttpInfo($authorization, $address, $password, $update_autoresponder, string $contentType = self::contentTypes['updateEmailAutoresponder'][0])
    {
        $returnType = '';
        $request = $this->updateEmailAutoresponderRequest($authorization, $address, $password, $update_autoresponder, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmailAutoresponder'
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\UpdateAutoresponder $update_autoresponder Autoresponder update details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailAutoresponder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateEmailAutoresponderRequest($authorization, $address, $password, $update_autoresponder, string $contentType = self::contentTypes['updateEmailAutoresponder'][0])
    {

        // verify the required parameter 'authorization' is set
        if ($authorization === null || (is_array($authorization) && count($authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling updateEmailAutoresponder'
            );
        }

        // verify the required parameter 'address' is set
        if ($address === null || (is_array($address) && count($address) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $address when calling updateEmailAutoresponder'
            );
        }

        // verify the required parameter 'password' is set
        if ($password === null || (is_array($password) && count($password) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $password when calling updateEmailAutoresponder'
            );
        }

        // verify the required parameter 'update_autoresponder' is set
        if ($update_autoresponder === null || (is_array($update_autoresponder) && count($update_autoresponder) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_autoresponder when calling updateEmailAutoresponder'
            );
        }


        $resourcePath = '/email-client/autoresponders/{autoresponder_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }
        // header params
        if ($address !== null) {
            $headerParams['Address'] = ObjectSerializer::toHeaderValue($address);
        }
        // header params
        if ($password !== null) {
            $headerParams['Password'] = ObjectSerializer::toHeaderValue($password);
        }



        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_autoresponder)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_autoresponder));
            } else {
                $httpBody = $update_autoresponder;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmailForwarders
     *
     * Updates email account&#39;s forwarders
     *
     * @param  string $authorization authorization (required)
     * @param  string $address address (required)
     * @param  string $password password (required)
     * @param  \OpenAPI\Client\Model\EmailForwardersUpdate $email_forwarders_update email_forwarders_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailForwarders'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateEmailForwarders($authorization, $address, $password, $email_forwarders_update, string $contentType = self::contentTypes['updateEmailForwarders'][0])
    {
        $this->updateEmailForwardersWithHttpInfo($authorization, $address, $password, $email_forwarders_update, $contentType);
    }

    /**
     * Operation updateEmailForwardersWithHttpInfo
     *
     * Updates email account&#39;s forwarders
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\EmailForwardersUpdate $email_forwarders_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailForwarders'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmailForwardersWithHttpInfo($authorization, $address, $password, $email_forwarders_update, string $contentType = self::contentTypes['updateEmailForwarders'][0])
    {
        $request = $this->updateEmailForwardersRequest($authorization, $address, $password, $email_forwarders_update, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateEmailForwardersAsync
     *
     * Updates email account&#39;s forwarders
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\EmailForwardersUpdate $email_forwarders_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailForwarders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmailForwardersAsync($authorization, $address, $password, $email_forwarders_update, string $contentType = self::contentTypes['updateEmailForwarders'][0])
    {
        return $this->updateEmailForwardersAsyncWithHttpInfo($authorization, $address, $password, $email_forwarders_update, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateEmailForwardersAsyncWithHttpInfo
     *
     * Updates email account&#39;s forwarders
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\EmailForwardersUpdate $email_forwarders_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailForwarders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmailForwardersAsyncWithHttpInfo($authorization, $address, $password, $email_forwarders_update, string $contentType = self::contentTypes['updateEmailForwarders'][0])
    {
        $returnType = '';
        $request = $this->updateEmailForwardersRequest($authorization, $address, $password, $email_forwarders_update, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmailForwarders'
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\EmailForwardersUpdate $email_forwarders_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailForwarders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateEmailForwardersRequest($authorization, $address, $password, $email_forwarders_update, string $contentType = self::contentTypes['updateEmailForwarders'][0])
    {

        // verify the required parameter 'authorization' is set
        if ($authorization === null || (is_array($authorization) && count($authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling updateEmailForwarders'
            );
        }

        // verify the required parameter 'address' is set
        if ($address === null || (is_array($address) && count($address) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $address when calling updateEmailForwarders'
            );
        }

        // verify the required parameter 'password' is set
        if ($password === null || (is_array($password) && count($password) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $password when calling updateEmailForwarders'
            );
        }

        // verify the required parameter 'email_forwarders_update' is set
        if ($email_forwarders_update === null || (is_array($email_forwarders_update) && count($email_forwarders_update) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $email_forwarders_update when calling updateEmailForwarders'
            );
        }


        $resourcePath = '/email-client/forwarders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }
        // header params
        if ($address !== null) {
            $headerParams['Address'] = ObjectSerializer::toHeaderValue($address);
        }
        // header params
        if ($password !== null) {
            $headerParams['Password'] = ObjectSerializer::toHeaderValue($password);
        }



        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($email_forwarders_update)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($email_forwarders_update));
            } else {
                $httpBody = $email_forwarders_update;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmailPassword
     *
     * Updates email account&#39;s password
     *
     * @param  string $authorization authorization (required)
     * @param  string $address address (required)
     * @param  string $password password (required)
     * @param  \OpenAPI\Client\Model\EmailPasswordUpdate $email_password_update email_password_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailPassword'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateEmailPassword($authorization, $address, $password, $email_password_update, string $contentType = self::contentTypes['updateEmailPassword'][0])
    {
        $this->updateEmailPasswordWithHttpInfo($authorization, $address, $password, $email_password_update, $contentType);
    }

    /**
     * Operation updateEmailPasswordWithHttpInfo
     *
     * Updates email account&#39;s password
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\EmailPasswordUpdate $email_password_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailPassword'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmailPasswordWithHttpInfo($authorization, $address, $password, $email_password_update, string $contentType = self::contentTypes['updateEmailPassword'][0])
    {
        $request = $this->updateEmailPasswordRequest($authorization, $address, $password, $email_password_update, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateEmailPasswordAsync
     *
     * Updates email account&#39;s password
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\EmailPasswordUpdate $email_password_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailPassword'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmailPasswordAsync($authorization, $address, $password, $email_password_update, string $contentType = self::contentTypes['updateEmailPassword'][0])
    {
        return $this->updateEmailPasswordAsyncWithHttpInfo($authorization, $address, $password, $email_password_update, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateEmailPasswordAsyncWithHttpInfo
     *
     * Updates email account&#39;s password
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\EmailPasswordUpdate $email_password_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailPassword'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmailPasswordAsyncWithHttpInfo($authorization, $address, $password, $email_password_update, string $contentType = self::contentTypes['updateEmailPassword'][0])
    {
        $returnType = '';
        $request = $this->updateEmailPasswordRequest($authorization, $address, $password, $email_password_update, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmailPassword'
     *
     * @param  string $authorization (required)
     * @param  string $address (required)
     * @param  string $password (required)
     * @param  \OpenAPI\Client\Model\EmailPasswordUpdate $email_password_update (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateEmailPassword'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateEmailPasswordRequest($authorization, $address, $password, $email_password_update, string $contentType = self::contentTypes['updateEmailPassword'][0])
    {

        // verify the required parameter 'authorization' is set
        if ($authorization === null || (is_array($authorization) && count($authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorization when calling updateEmailPassword'
            );
        }

        // verify the required parameter 'address' is set
        if ($address === null || (is_array($address) && count($address) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $address when calling updateEmailPassword'
            );
        }

        // verify the required parameter 'password' is set
        if ($password === null || (is_array($password) && count($password) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $password when calling updateEmailPassword'
            );
        }

        // verify the required parameter 'email_password_update' is set
        if ($email_password_update === null || (is_array($email_password_update) && count($email_password_update) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $email_password_update when calling updateEmailPassword'
            );
        }


        $resourcePath = '/email-client/password';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }
        // header params
        if ($address !== null) {
            $headerParams['Address'] = ObjectSerializer::toHeaderValue($address);
        }
        // header params
        if ($password !== null) {
            $headerParams['Password'] = ObjectSerializer::toHeaderValue($password);
        }



        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($email_password_update)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($email_password_update));
            } else {
                $httpBody = $email_password_update;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
